<?php 
$default_settings = [
    'image' => '',
    'image_type' => '',
    'title' => '',
    'description' => '',
    'button_text' => '',
    'button_link' => '',
];
$settings = array_merge($default_settings, $settings);
extract($settings);

if ( ! empty( $settings['image']['url'] ) ) {
    $widget->add_render_attribute( 'image', 'src', $settings['image']['url'] );
    $widget->add_render_attribute( 'image', 'alt', \Elementor\Control_Media::get_image_alt( $settings['image'] ) );
    $widget->add_render_attribute( 'image', 'title', \Elementor\Control_Media::get_image_title( $settings['image'] ) );
}
$image_html = \Elementor\Group_Control_Image_Size::get_attachment_image_html( $settings, 'thumbnail', 'image' );

if ( ! empty( $button_link['url'] ) ) {
    $widget->add_render_attribute( 'button', 'href', $button_link['url'] );

    if ( $button_link['is_external'] ) {
        $widget->add_render_attribute( 'button', 'target', '_blank' );
    }

    if ( $button_link['nofollow'] ) {
        $widget->add_render_attribute( 'button', 'rel', 'nofollow' );
    }
}
?>
<div class="ct-video-player btn-video-<?php echo esc_attr($settings['btn_video_style']); ?> <?php if(!empty($title) || !empty($description)) { echo 'meta-active'; } ?> <?php echo esc_attr($settings['ct_animate']); ?>" data-wow-delay="<?php echo esc_attr($settings['ct_animate_delay']); ?>ms">
    <div class="ct-video-box">
        <div class="ct-video-holder">
            <?php if ($image_type == 'img') { ?>
                <?php if ( ! empty( $settings['image']['url'] ) ) { echo wp_kses_post($image_html); } ?>
            <?php } else { ?>
                <div class="ct-video-image-bg bg-image" style="background-image: url(<?php echo esc_url($image['url']); ?>);"></div>
            <?php } ?>
        </div>
        <?php if(!empty($settings['video_link'])) : ?>
            <a class="ct-video-button <?php if ( ! empty( $settings['image']['url'] ) ) { echo 'img-active'; } ?> <?php echo esc_attr($settings['btn_video_style']); ?>" href="<?php echo esc_url($settings['video_link']); ?>">
                <i class="fac fac-play"></i>
            </a>
        <?php endif; ?>
    </div>
    <?php if(!empty($title) || !empty($description)) : ?>
        <div class="ct-video-meta">
            <?php if(!empty($title)) : ?>
                <h4><?php echo esc_attr($title); ?></h4>
            <?php endif; ?>
            <p><?php echo ct_print_html($description); ?></p>
            <a <?php ct_print_html($widget->get_render_attribute_string( 'button' )); ?> class="btn"><?php echo esc_attr($button_text); ?></a>
        </div>
    <?php endif; ?>
</div>